//--------------------------------------------------------------------------------------
// File: EmptyProject.fx
//
// The effect file for the EmptyProject sample.  
// 
// Copyright (c) Microsoft Corporation. All rights reserved.
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
float appTime;  //App's time in seconds
float4x4 worldMatrix;  // World matrix for object
float4x4 worldViewProjection;	// World * View * Projection matrix
float alphamin;
float alphamax;
float4 light;
float4 view;
float dz;

texture volumetex;
texture lookuptex;

texture fronttex;
texture backtex;

texture screentex;

struct VS_INPUT 
{
   float3 Position : POSITION0;
   float4 Color : COLOR0;    
   float2 Texcoord : TEXCOORD0;    
};

struct VS_OUTPUT 
{
   float4 Position : POSITION0;
   float4 Color : COLOR0;   
   float2 Texcoord : TEXCOORD0;   
};


VS_OUTPUT vs_main( VS_INPUT Input )
{
   VS_OUTPUT Output;   
   
   float4 temp = mul( float4(Input.Position,1), worldMatrix );
   
   Output.Position = mul( temp, worldViewProjection );     
   
   Output.Color = Input.Color;
   
   Output.Texcoord = Input.Texcoord;
   
   return( Output );   
}

sampler3D baseMap = sampler_state{
	Texture = <volumetex>;
	MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = BORDER;
    AddressV = BORDER; 
    AddressW = BORDER; 
};

sampler2D lookMap = sampler_state{
	Texture = <lookuptex>;
	MinFilter = POINT;
    MagFilter = POINT;
};

sampler2D frontMap = sampler_state{
	Texture = <fronttex>;
	MinFilter = POINT;
    MagFilter = POINT;
};

sampler2D backMap = sampler_state{
	Texture = <backtex>;
	MinFilter = POINT;
    MagFilter = POINT;
};

sampler2D screenMap = sampler_state{
	Texture = <screentex>;
	MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct PS_INPUT
{   
   float4 Color : COLOR0;   
};

struct PS_INPUT2 
{   
   float4 Color : COLOR0;   
   float2 Texcoord : TEXCOORD0;   
};

float3 expand(float3 v){	
	return (v - 0.5f) * 2.0f;	
}

float4 ps_main( PS_INPUT Input ) : COLOR0
{      
   return Input.Color;    
}

float4 ps_main2( PS_INPUT2 Input ) : COLOR0
{    
   //dz = 0.005f;
   
   float4 entry = tex2Dlod(frontMap, float4(Input.Texcoord,0.0f,0.0f));
   
   float4 exit = tex2Dlod(backMap,  float4(Input.Texcoord,0.0f,0.0f));
   
   float dist = distance(entry,exit)/dz;
   
   float4 color = float4(0.0f,0.0f,0.0f,0.0f);
   
   
   if(dist > 0.0f)
   {   
	   int maxiter = int(floor(dist));
	   
	   float3 slope = (exit.xyz - entry.xyz) / dist;   
	   
	   float4 start = entry;	
	   
	   float4 intensity = float4(0.0f,0.0f,0.0f,0.0f);   
	   	
	   float3 gradient;
	   
	   float len;
	   
		bool proceed = true;
		int i = 0;
		while(proceed){
			intensity = tex3Dlod(baseMap, float4(start.xyz,0.0f));   			 
			
			float4 transfer = tex2Dlod(lookMap, float4(intensity.a, intensity.a / 64, 0.0f, 0.0f));   		
			
			start.xyz += slope.xyz;	
			
			gradient = normalize(expand(intensity.xyz));              
			len = abs(gradient);			
			// lighting			
		   float diffuse =  dot(gradient, light);	   
		   if(diffuse < 0.0f) diffuse = 0.0f;
		   
		   //float3 halfvec = normalize(light.xyz + view.xyz);
		   
		   //float specular = pow(dot(halfvec,gradient),8);
		   //if(diffuse == 0.0f) specular = 0.0f;	
			
			//
		   if(transfer.a < alphamin) transfer.a = 0.0f;
		   if(transfer.a < alphamax) transfer.a = transfer.a * len;		
		   
		   color.rgb += 0.75f * (1.0f - color.a) * transfer.rgb * transfer.a 
		   			  + 0.5f * (1.0f - color.a) * diffuse * transfer.rgb * transfer.a;
		   		  //+ 2.0f * (1.0f - color.a) * specular * float3(1.0f,1.0f,1.0f) * transfer.a;
		   //color.rgb += (1.0f - color.a) * transfer.rgb * transfer.a;
		   color.a += (1.0f - color.a) * transfer.a;
			
			i++;
			
			if(color.a >= 1.0f || i > maxiter) proceed = false;  
	   }	         
   } else color = float4(0.0f,0.0f,0.0f,0.0f);
   return color;
}

float4 ps_main3( PS_INPUT2 Input ) : COLOR0
{      
   return tex2Dlod(screenMap, float4(Input.Texcoord,0.0f,0.0f));   
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------
technique Raycasting
{
    pass P0
    {   
        VertexShader = compile vs_3_0 vs_main();
        PixelShader  = compile ps_3_0 ps_main();       
    }
    pass P1
    {   
        VertexShader = compile vs_3_0 vs_main();
        PixelShader  = compile ps_3_0 ps_main();       
    }
    pass P2
    {   
        VertexShader = compile vs_3_0 vs_main();
        PixelShader  = compile ps_3_0 ps_main2();       
    }
    pass P3
    {   
        VertexShader = compile vs_3_0 vs_main();
        PixelShader  = compile ps_3_0 ps_main3();       
    }
}
